﻿# Run PowerShell script in Administrator mode
if (!([Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)) {
    Start-Process PowerShell -Verb RunAs "-NoProfile -ExecutionPolicy Bypass -Command `"cd '$pwd'; & '$PSCommandPath';`"";
    exit;
}
# Initialize the path for virtual disk
$Virtual_Disk_Path = ""
$Virtual_Disk_For_SQL_Installer_Substituted = $false
$BFM_Folder_Virtual_Disk_Path = ""
try {
    # Initialize the output from substitution of virtual disk
    $SubstVirtualDiskOutput = ""
    
    # Loop from Z to A, ASCII decimal of Z is 90 while the ASCII decimal of A is 65
    for ($ASCII_Decimal = 90; $ASCII_Decimal -ge 65; $ASCII_Decimal--)
    {
        # Reset SubstVirtualDiskOutput variable to empty string on each iteration
        $SubstVirtualDiskOutput = ""
        # Assign alphabet (Z to A) and colon as value of Virtual_Disk_Path variable
        $Virtual_Disk_Path = [char]($ASCII_Decimal) + ":"
        # Associate the SetupPrerequisites folder to a virtual disk, using the built-in utility Subst
        # Subtitute a virtual disk with the PowerShell script folder which is in the SetupPrerequisites folder of SQL Server 2012 installation
        $SubstVirtualDiskOutput = Subst $Virtual_Disk_Path $PSScriptRoot
        
        # If the virtual disk has been substituted previously, the output is "Drive already SUBSTed"
        # If the value of Virtual_Disk_Path variable is invalid, the output is "Invalid parameter - $Virtual_Disk_Path"
        # If the virtual disk is substituted successfully, the output is nullified
        if ($SubstVirtualDiskOutput -eq $null){
            $Virtual_Disk_For_SQL_Installer_Substituted = $true
            break
        }
    }

    if ( $Virtual_Disk_For_SQL_Installer_Substituted ) {
        $BFM_Folder_Virtual_Disk_Path = $Virtual_Disk_Path + "\MSBFM40"
        # Make a new directory on virtual disk for Battery Fleet Management
        if (Test-Path -Path $BFM_Folder_Virtual_Disk_Path) {
            echo "MSBFM40 folder already exists. "
            # Delete the BFM folder
            Remove-Item $BFM_Folder_Virtual_Disk_Path -Recurse
            # Create the BFM folder
            New-Item -ItemType "directory" -Path $BFM_Folder_Virtual_Disk_Path
        }
        else {
            # Create the BFM folder
            New-Item -ItemType "directory" -Path $BFM_Folder_Virtual_Disk_Path
        }
    
    
        Add-Type -AssemblyName System.IO.Compression.FileSystem

        function Unzip
        {
            param([string]$zipfile, [string]$outpath)

            [System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
        }
        # Full path of SQL_EXPRESS_EXTRACTED_FILES_W_SETUP.zip zipped folder
        # PSScriptRoot is the full path of the current PowerShell script
        # $Zipped_Folder_Path = $PSScriptRoot + "\SQL_Installer.zip"
        
        # SQL_Installer.zip is in the SetupPrerequisites folder of SQL Server 2012 installation and the virtual disk is associated to the SetupPrerequisites folder
        $Zipped_Folder_Path = $Virtual_Disk_Path + "\SQL_Installer.zip"
    
        # Unzip SQL_EXPRESS_EXTRACTED_FILES_W_SETUP.zip zipped folder that contains SQL Server 2012 and SQLEXPRESS Installer Setup Files
        # Unzip $Zipped_Folder_Path $PSScriptRoot
        # Unzip SQL_Installer.zip located on the virtual disk to Battery Fleet Management folder on the virtual disk
        Unzip $Zipped_Folder_Path $BFM_Folder_Virtual_Disk_Path
    }
    else {
        Add-Type -AssemblyName PresentationFramework
        $MessageBoxTitle = "Couldn't Substitute Virtual Disk"
        $MessageBoxBody = "All alphabets have been used to substitute virtual disk before the SQL Server 2012 installation. You might need to delete one virtual disk and rerun the setup.exe of Motorola IMPRES Battery Fleet Management."
        $MessageIcon = [System.Windows.MessageBoxImage]::Warning
        $ButtonType = [System.Windows.MessageBoxButton]::OK
        $MessageBoxResult = [System.Windows.MessageBox]::Show($MessageBoxBody,$MessageBoxTitle,$ButtonType,$MessageIcon)
    }
}
catch {
    echo "Error: $_"
    Start-Sleep -Seconds 60
}

# Start-Sleep -Seconds 20

# Full path of ConfigurationFileTemplate.ini file and ConfigurationFile.ini file 
# $ConfigurationFileTemplate_ini = $PSScriptRoot + "\SQL_EXPRESS_EXTRACTED_FILES_W_SETUP\ConfigurationFileTemplate.ini"
# $ConfigurationFileTemplate_ini = $PSScriptRoot + "\ConfigurationFileTemplate.ini"
$ConfigurationFileTemplate_ini = $BFM_Folder_Virtual_Disk_Path + "\ConfigurationFileTemplate.ini"

# $ConfigurationFile_ini = $PSScriptRoot + "\SQL_EXPRESS_EXTRACTED_FILES_W_SETUP\ConfigurationFile.ini"
# $ConfigurationFile_ini = $PSScriptRoot + "\ConfigurationFile.ini"
$ConfigurationFile_ini = $BFM_Folder_Virtual_Disk_Path + "\ConfigurationFile.ini"

# Initialize SQLACCOUNT_Line and ACTION_Line variable
$SQLACCOUNT_Line = "ABC"
$ACTION_Line = "ABC"

try {
    if ( $Virtual_Disk_For_SQL_Installer_Substituted ) {
        # Get username with whoami command and store the string in a variable
        $whoami_var = whoami
        # Read line by line from ConfigurationFileTemplate.ini file and search for SQLSYSADMINACCOUNTS and modify the line with whoami variable
        # and then write the content ConfigurationFile.ini file
        foreach($line in Get-Content -Path $ConfigurationFileTemplate_ini) {
            if($line -match "SQLSYSADMINACCOUNTS=") {
                # Set whoami string to SQLSYSADMINACCOUNTS
                $SQLACCOUNT_Line = "SQLSYSADMINACCOUNTS=" + '"' + $whoami_var.ToUpper() + '"'
                Add-Content -Path $ConfigurationFile_ini -Value $SQLACCOUNT_Line
            }
            else {
                Add-Content -Path $ConfigurationFile_ini -Value $line
            }
        }
    }
}
catch {
    echo "Error: $_"
    Start-Sleep -Seconds 30
}

# Full path of SETUP.EXE executable file
# $Setup_DOT_EXE_Path = $PSScriptRoot + "\SQL_EXPRESS_EXTRACTED_FILES_W_SETUP\3289bcecc2d7486171d7ba\SETUP.EXE"
# $Setup_DOT_EXE_Path = $PSScriptRoot + "\SETUP.EXE"
$Setup_DOT_EXE_Path = $BFM_Folder_Virtual_Disk_Path + "\SETUP.EXE"


try {
    if ( $Virtual_Disk_For_SQL_Installer_Substituted ) {
        # Run SETUP.EXE with CONFIGURATIONFILE as parameter
        & $Setup_DOT_EXE_Path /CONFIGURATIONFILE=$ConfigurationFile_ini
    }
}
catch {
    echo "Error: $_"
    Start-Sleep -Seconds 30
}

try {
    if ($Virtual_Disk_For_SQL_Installer_Substituted -and (Test-Path -Path $BFM_Folder_Virtual_Disk_Path)) {
        # Delete the BFM folder
        Remove-Item $BFM_Folder_Virtual_Disk_Path -Recurse
    }
}
catch {
    echo "Error: $_"
    Start-Sleep -Seconds 30
}

try {
    if ( $Virtual_Disk_For_SQL_Installer_Substituted ) {
        # Delete the virtual disk
	    Subst $Virtual_Disk_Path /d
    }
}
catch {
    echo "Error: $_"
    Start-Sleep -Seconds 30
}

# Sleep for a few seconds so that software developers can view the error message if there are any
# Start-Sleep -Seconds 20